	function crep = chooserep(creps, class, rep)
	%crep = chooserep(creps, class, rep)
	%
	%Chooses one of the coefficient representations for an FIR filter.
	%
	%Arguments:
	%  creps - structure generated by gencoeffreps
	%  class - the class to choose from: 'bin' or 'msd'
	%  rep - ID of the representation if the class has multiple
	%        representations. Needed for 'msd'.
	%
	%Returns:
	%  crep - structure describing the chosen representation
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	if class == 'bin'
		hcoeffs = [];
		id = 0;
		for n = 1:length(creps.bin)
			hcoeffs = [hcoeffs; creps.bin{n}];
		end
	elseif class == 'msd'
		hcoeffs = [];
		id = rep;
		for n = 1:length(creps.msd)
			terms = creps.msd{n};
			r = mod(rep, size(terms, 1));
			term = terms(r+1, :);
			rep = (rep-r)/size(terms, 1);
			
			hcoeffs = [hcoeffs;term];
		end
	else
		error 'chooserep: Illegal class'
	end
	
	crep.h = creps.h;
	crep.wc = creps.wc;
	crep.class = class;
	crep.id = id;
	crep.coeffs = hcoeffs;
	
